<?php
/* --------------------------------------------------------------
   UserConfigurationRepository.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Repository;

use Gambio\Admin\UserConfiguration\Interfaces\UserConfiguration;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationKey;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationRepository as UserConfigurationRepositoryInterface;
use Gambio\Admin\UserConfiguration\Interfaces\UserId;
use Gambio\Admin\UserConfiguration\Model\UserConfiguration as UserConfigurationModel;

/**
 * Class UserConfigurationRepository
 *
 * @package Gambio\Admin\UserConfiguration\Repository
 */
class UserConfigurationRepository implements UserConfigurationRepositoryInterface
{
    /**
     * @var UserConfigurationReader
     */
    private $reader;
    
    /**
     * @var UserConfigurationWriter
     */
    private $writer;
    
    
    /**
     * UserConfigurationRepository constructor.
     *
     * @param UserConfigurationReader $reader
     * @param UserConfigurationWriter $writer
     */
    public function __construct(UserConfigurationReader $reader, UserConfigurationWriter $writer)
    {
        $this->reader = $reader;
        $this->writer = $writer;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getByKey(UserId $userId, UserConfigurationKey $key): UserConfiguration
    {
        $value = $this->reader->getConfigurationValue($userId, $key);
        
        return UserConfigurationModel::create($key, $value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function store(UserId $userId, UserConfiguration $configuration): void
    {
        $this->writer->store($userId, $configuration);
    }
    
    
    /**
     * @inheritDoc
     */
    public function deleteByKey(UserId $userId, UserConfigurationKey $key): void
    {
        $this->writer->delete($userId, $key);
    }
}